#include "stdafx.h"
#include "CCaptureDeviceh.h"

#include "resource.h"

extern VOID DumpDebugMessage( CHAR * fmt, ... );

extern HMODULE g_hModule;

extern SETUP_RECORD_PROPERTY_EX gScm;

CCaptureDevice::CCaptureDevice()
{
	m_hAttachedWindow								= NULL;

	m_hCorrectAttachedWindow						= NULL;

	m_bIsDeviceAvailable							= FALSE;	

	m_hVideoDevice									= NULL;

	m_hMySetupUIInstance							= NULL;

	m_lpfn_MySetupDlg								= NULL;
}

CCaptureDevice::~CCaptureDevice()
{
	if ( m_hMySetupUIInstance != NULL )
	{
		FreeLibrary( m_hMySetupUIInstance );

		m_hMySetupUIInstance = NULL;
	}
}

CString CCaptureDevice::GetWorkingPath(CString strWorkFile)
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	strCurPath += "Plug-ins\\Common\\";

	strCurPath += strWorkFile;

	return strCurPath;
}

BOOL CCaptureDevice::IsFileExists(const TCHAR * pszFile)
{
	WIN32_FIND_DATA FindFileData;

	HANDLE hFind = INVALID_HANDLE_VALUE;

	hFind = FindFirstFile(pszFile, &FindFileData);

	if (hFind == INVALID_HANDLE_VALUE) { return FALSE; }	

	FindClose(hFind);

	return TRUE;
}

VOID CCaptureDevice::SetDeviceName(CHAR * pszDeviceName)
{
	m_strDeviceName = pszDeviceName;

	m_strDeviceName += " PCI";
}

BOOL CCaptureDevice::Initialize()
{
	QRESULT qResult = QCAP_RS_ERROR_GENERAL;

	qResult = QCAP_CREATE( m_strDeviceName.GetBuffer( MAX_PATH ), 0, m_hCorrectAttachedWindow, &m_hVideoDevice, 0, 1);

	m_strDeviceName.ReleaseBuffer();

	if ( qResult != QCAP_RS_SUCCESSFUL) { return FALSE; }

	QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice, 0 );

	QCAP_SET_AUDIO_VOLUME( m_hVideoDevice, 100);

	QCAP_SET_AUDIO_INPUT( m_hVideoDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	qResult = QCAP_SET_VIDEO_INPUT( m_hVideoDevice, QCAP_INPUT_TYPE_AUTO );

	if ( qResult != QCAP_RS_SUCCESSFUL) { return FALSE; }

	m_bIsDeviceAvailable = TRUE;

	return TRUE;
}

BOOL CCaptureDevice::UnInitialize()
{
	if ( m_hVideoDevice == NULL ) { return FALSE; }
		
	QCAP_STOP( m_hVideoDevice );

	QCAP_DESTROY( m_hVideoDevice );	

	m_hVideoDevice = NULL;

	m_bIsDeviceAvailable = FALSE;

	return TRUE;
}

VOID CCaptureDevice::Shartup()
{

}

VOID CCaptureDevice::ShutDown()
{	
	
}

BOOL CCaptureDevice::SetAttachedWindow(HWND hAttachedWindow)
{
	if ( m_hAttachedWindow != hAttachedWindow )
	{
		m_hAttachedWindow = hAttachedWindow;
	}

	if ( m_hAttachedWindow == NULL ) { return FALSE; }

	m_hCorrectAttachedWindow = m_hAttachedWindow;

	return TRUE;
}

BOOL CCaptureDevice::StartPreview()
{
	if ( m_hVideoDevice == NULL ) { return FALSE; }
		
	ULONG qResult = QCAP_RS_ERROR_GENERAL;

	qResult = QCAP_RUN( m_hVideoDevice );

	if ( qResult != QCAP_RS_SUCCESSFUL ) { return FALSE; }

	return TRUE;
}

BOOL CCaptureDevice::StopPreview()
{	
	if ( m_hVideoDevice == NULL ) { return FALSE; }
		
	ULONG qResult = QCAP_RS_ERROR_GENERAL;

	qResult = QCAP_STOP( m_hVideoDevice );

	if ( qResult != QCAP_RS_SUCCESSFUL ) { return FALSE; }

	return TRUE;
}

BOOL CCaptureDevice::StartRecord()
{
	if ( m_hVideoDevice == NULL ) { return FALSE; }

	SETUP_RECORD_PROPERTY_EX *pscm = &gScm;

	ULONG qResult = QCAP_RS_ERROR_GENERAL;

	CHAR pszRecordFilePathName[ 512 ] = {0};
	lstrcpy( pszRecordFilePathName, pscm->pszRecordFilePathName );
	ULONG	nEncoderType		= pscm->nEncoderType;
	ULONG	nEncoderFormat		= pscm->nEncoderFormat;
	ULONG	nRecordProfile		= pscm->nRecordProfile;
	ULONG	nRecordLevel		= pscm->nRecordLevel;
	ULONG	nRecordComplexity	= pscm->nRecordComplexity;
	ULONG	nRecordEntropy		= pscm->nRecordEntropy;
	ULONG	nRecordMode			= pscm->nRecordMode;
	ULONG	nQuality			= pscm->nQuality;
	ULONG	nBitRate			= pscm->nBitRate;
	ULONG	nGOP				= pscm->nGOP;
	ULONG	nBFrames			= pscm->nBFrames;
	ULONG	bIsInterleaved		= pscm->bIsInterleaved;		
	ULONG	nCropX				= pscm->nCropX;
	ULONG	nCropY				= pscm->nCropY;
	ULONG	nCropW				= pscm->nCropW;
	ULONG	nCropH				= pscm->nCropH;
	ULONG	nDstH				= pscm->nDstH;
	ULONG	nDstW				= pscm->nDstW;
	ULONG	nAspectRatioX		= pscm->nAspectRatioX;
	ULONG	nAspectRatioY		= pscm->nAspectRatioY;

	qResult = QCAP_SET_VIDEO_RECORD_PROPERTY_EX( m_hVideoDevice, 0, nEncoderType,  nEncoderFormat,  nRecordProfile, nRecordLevel, nRecordEntropy, nRecordComplexity, nRecordMode,  nQuality, nBitRate,  nGOP,  nBFrames
		
		, bIsInterleaved, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, nAspectRatioX,  nAspectRatioY,  nCropX, nCropY, nCropW, nCropH, nDstW, nDstH, 0, 0 );

	if ( qResult != QCAP_RS_SUCCESSFUL ) { return FALSE; }

	qResult = QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 0, 0, QCAP_ENCODER_FORMAT_PCM );	

	qResult = QCAP_START_RECORD( m_hVideoDevice, 0, pszRecordFilePathName, QCAP_RECORD_FLAG_FULL );

//	if ( qResult != QCAP_RS_SUCCESSFUL ) { return FALSE; }

	return TRUE;
}

BOOL CCaptureDevice::PauseRecord()
{
	if ( m_hVideoDevice == NULL ) { return FALSE; }

	ULONG qResult = QCAP_RS_ERROR_GENERAL;

	qResult = QCAP_PAUSE_RECORD( m_hVideoDevice, 0 );

	if ( qResult != QCAP_RS_SUCCESSFUL ) { return FALSE; }

	return TRUE;
}

BOOL CCaptureDevice::StopRecord()
{	
	if ( m_hVideoDevice == NULL ) { return FALSE; }

	ULONG qResult = QCAP_RS_ERROR_GENERAL;

	qResult = QCAP_STOP_RECORD( m_hVideoDevice, 0 );

	if ( qResult != QCAP_RS_SUCCESSFUL ) { return FALSE; }

	return TRUE;
}

int CCaptureDevice::ShowSetupUIDialog()
{
//	CString strMyUIPathName = GetWorkingPath( "MySetupUI.X64.DLL" );

	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName( g_hModule, szCurPath, MAX_PATH);

	CString strMyUIPathName = szCurPath;

	strMyUIPathName = strMyUIPathName.Left(strMyUIPathName.ReverseFind('\\') + 1);

#ifdef SA7160_CAP_X64
		strMyUIPathName += "SA7160.CAP.UI.X64.DLL";
#endif

	DumpDebugMessage( (CHAR*)(LPCSTR)strMyUIPathName );

	TCHAR szOutput[ MAX_PATH ];

	if ( !IsFileExists( strMyUIPathName ) ) 
	{ 
		sprintf( szOutput, " Setup UI File not found -> %s \n", strMyUIPathName ); DumpDebugMessage( szOutput );

		return FALSE; 
	}

	if ( m_hMySetupUIInstance != NULL )
	{
		FreeLibrary( m_hMySetupUIInstance );

		m_hMySetupUIInstance = NULL;
	}

	m_hMySetupUIInstance = LoadLibraryEx( strMyUIPathName, NULL, LOAD_WITH_ALTERED_SEARCH_PATH ); // DONT_RESOLVE_DLL_REFERENCES 

	if ( m_hMySetupUIInstance == NULL )
	{
		sprintf( szOutput, "FAIL TO LOAD MY SETUP UI DLL = %s \n", strMyUIPathName ); DumpDebugMessage( szOutput );

		return FALSE;
	}
	else
	{
		sprintf( szOutput, "SUCCESS TO LOAD MY SETUP UI DLL = %s \n", strMyUIPathName ); DumpDebugMessage( szOutput );

		m_lpfn_MySetupDlg = (_INVOKE_SETUP_DIALOG)GetProcAddress(m_hMySetupUIInstance, "InvokeSetupDialog");

		if ( m_lpfn_MySetupDlg == NULL ) { sprintf( szOutput, "FAIL TO LOAD MY SETUP UI FUNCTION : InvokeSetupDialog \n" ); DumpDebugMessage( szOutput ); return FALSE; }
	}		

	if ( m_lpfn_MySetupDlg == NULL ) { return FALSE; }

	// INVOKE MY SETUP DIALOG
	//
	SETUP_RECORD_PROPERTY_EX *pScm = &gScm;

	m_lpfn_MySetupDlg( pScm );

	return TRUE;
}

